unit Testdll;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls,
  DICDLL, Spin;

type
  TShowData = class(TForm)
    ShowData: TTimer;
    Label1: TLabel;
    CheckTimerBox: TCheckBox;
    Label2: TLabel;
    CheckCounterBox: TCheckBox;
    CounterSet: TEdit;
    TimerSet: TEdit;
    DDMCount0: TEdit;
    DDMCount1: TEdit;
    DDMCount2: TEdit;
    DDMCount3: TEdit;
    DDMTim0: TEdit;
    DDMTim1: TEdit;
    DDMTim2: TEdit;
    DDMTim3: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    DICadresse: TLabel;
    Reset0: TButton;
    Reset1: TButton;
    Reset2: TButton;
    Reset3: TButton;
    Reset: TLabel;
    ResetAll: TButton;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Dout7: TCheckBox;
    Dout6: TCheckBox;
    Dout5: TCheckBox;
    Dout4: TCheckBox;
    Dout3: TCheckBox;
    Dout2: TCheckBox;
    Dout1: TCheckBox;
    Dout0: TCheckBox;
    Din7: TCheckBox;
    Din6: TCheckBox;
    Din5: TCheckBox;
    Din4: TCheckBox;
    Din3: TCheckBox;
    Din2: TCheckBox;
    Din1: TCheckBox;
    Din0: TCheckBox;
    Label20: TLabel;
    DDMStatus0: TEdit;
    DDMStatus1: TEdit;
    DDMStatus2: TEdit;
    DDMStatus3: TEdit;
    Aout0: TLabel;
    Aout1: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Fil0: TCheckBox;
    Fil1: TCheckBox;
    Fil2: TCheckBox;
    Fil3: TCheckBox;
    Td0: TCheckBox;
    Td1: TCheckBox;
    Td2: TCheckBox;
    Td3: TCheckBox;
    Label23: TLabel;
    DigiOut: TLabel;
    DigiIn: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    IRQ: TLabel;
    Label26: TLabel;
    DLL: TLabel;
    Count: TSpinEdit;
    HighTim: TSpinEdit;
    LowTim: TSpinEdit;
    Label27: TLabel;
    Label28: TLabel;
    Aout0Int: TSpinEdit;
    Aout1Int: TSpinEdit;
    Label29: TLabel;
    Aout0Value: TLabel;
    Aout1Value: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label31: TLabel;
    Label32: TLabel;
    Bevel3: TBevel;
    Label33: TLabel;
    Label34: TLabel;
    procedure VersionsCheck;
    procedure ShowDataTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckTimerBoxClick(Sender: TObject);
    procedure CheckCounterBoxClick(Sender: TObject);
    procedure Reset0Click(Sender: TObject);
    procedure Reset1Click(Sender: TObject);
    procedure Reset2Click(Sender: TObject);
    procedure Reset3Click(Sender: TObject);
    procedure ResetAllClick(Sender: TObject);
    procedure Fil0Click(Sender: TObject);
    procedure Fil1Click(Sender: TObject);
    procedure Fil2Click(Sender: TObject);
    procedure Fil3Click(Sender: TObject);
    procedure Td0Click(Sender: TObject);
    procedure Td1Click(Sender: TObject);
    procedure Td2Click(Sender: TObject);
    procedure Td3Click(Sender: TObject);
    procedure Aout0IntChange(Sender: TObject);
    procedure Aout1IntChange(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  ShowData: TShowData;
  DICADR : integer;
  IRQHLP : integer;

const
  DICDLLConst =10;

implementation

{$R *.DFM}

procedure TShowData.VersionsCheck;
begin
     if (Version<DICDLLConst)then
     begin
        MessageDlg('Obsolete DIC.DLL version found'+#10#13+'Program terminated', mtError, [mbOk], 0);
        Application.Terminate;
     end;
end;

procedure TShowData.ShowDataTimer(Sender: TObject);

begin
     if (DICReadDigital(7)=1) then Din7.checked:=True else Din7.checked:=False;
     if (DICReadDigital(6)=1) then Din6.checked:=True else Din6.checked:=False;
     if (DICReadDigital(5)=1) then Din5.checked:=True else Din5.checked:=False;
     if (DICReadDigital(4)=1) then Din4.checked:=True else Din4.checked:=False;
     if (DICReadDigital(3)=1) then Din3.checked:=True else Din3.checked:=False;
     if (DICReadDigital(2)=1) then Din2.checked:=True else Din2.checked:=False;
     if (DICReadDigital(1)=1) then Din1.checked:=True else Din1.checked:=False;
     if (DICReadDigital(0)=1) then Din0.checked:=True else Din0.checked:=False;

     if Dout7.checked then DICWriteDigital(7,1)else DICWriteDigital(7,0);
     if Dout6.checked then DICWriteDigital(6,1)else DICWriteDigital(6,0);
     if Dout5.checked then DICWriteDigital(5,1)else DICWriteDigital(5,0);
     if Dout4.checked then DICWriteDigital(4,1)else DICWriteDigital(4,0);
     if Dout3.checked then DICWriteDigital(3,1)else DICWriteDigital(3,0);
     if Dout2.checked then DICWriteDigital(2,1)else DICWriteDigital(2,0);
     if Dout1.checked then DICWriteDigital(1,1)else DICWriteDigital(1,0);
     if Dout0.checked then DICWriteDigital(0,1)else DICWriteDigital(0,0);

     DigiOut.Caption := IntToStr(DICGetDigitalOut and 255);
     DigiIn.Caption := IntToStr(DICReadAllDigital);


     If CheckCounterBox.Checked then CounterSet.Text:=IntToStr(DICGetCounter);
     If CheckTimerBox.Checked then TimerSet.Text:=IntToStr(DICGetTimer);

     DICReadAllDDM;

     DDMCount0.Text:=IntToStr(DICGetDDMCounter(0));
     DDMCount1.Text:=IntToStr(DICGetDDMCounter(1));
     DDMCount2.Text:=IntToStr(DICGetDDMCounter(2));
     DDMCount3.Text:=IntToStr(DICGetDDMCounter(3));

     DDMTim0.Text:=IntToStr(DICGetDDMTimer(0));
     DDMTim1.Text:=IntToStr(DICGetDDMTimer(1));
     DDMTim2.Text:=IntToStr(DICGetDDMTimer(2));
     DDMTim3.Text:=IntToStr(DICGetDDMTimer(3));

     DDMStatus0.Text:=IntToStr(DICGetDDMStatus(0));
     DDMStatus1.Text:=IntToStr(DICGetDDMStatus(1));
     DDMStatus2.Text:=IntToStr(DICGetDDMStatus(2));
     DDMStatus3.Text:=IntToStr(DICGetDDMStatus(3));
end;

procedure TShowData.FormCreate(Sender: TObject);
begin
  DICADR:=$310;
  IRQHLP:=0;

  DICDRVInit( DICADR );

  VersionsCheck;

  DICadresse.Caption:=IntToHex(DICGetAdress,3);
  IRQ.Caption:=IntToStr(DICGetInterrupt);
  DLL.Caption:=IntToStr(Version);

  DicSetCounter(Count.Value);
  DicSetTimerWord((HighTim.Value shl 16) or LowTim.Value);

  DICWriteAnalogInt(0,Aout0Int.Value);
  DICWriteAnalogInt(1,Aout1Int.Value);

  If CheckTimerBox.Checked then DICGateTimer(1)
  else DICGateTimer(0);

  If CheckCounterBox.Checked then DICGateCounter(1)
  else DICGateCounter(0);

end;

procedure TShowData.CheckTimerBoxClick(Sender: TObject);
begin
    If CheckTimerBox.Checked then
    begin
         DicSetTimerWord((HighTim.Value shl 16) or LowTim.Value);
         DICGateTimer(1);
    end
     else DICGateTimer(0);
end;

procedure TShowData.CheckCounterBoxClick(Sender: TObject);
begin
     If CheckCounterBox.Checked then
    begin
         DicSetCounter(Count.Value);
         DICGateCounter(1);
    end
     else DICGateCounter(0);
end;

procedure TShowData.Reset0Click(Sender: TObject);
begin
     DICResetDDM(0);
end;

procedure TShowData.Reset1Click(Sender: TObject);
begin
     DICResetDDM(1);
end;

procedure TShowData.Reset2Click(Sender: TObject);
begin
     DICResetDDM(2);
end;

procedure TShowData.Reset3Click(Sender: TObject);
begin
     DICResetDDM(3);
end;

procedure TShowData.ResetAllClick(Sender: TObject);
begin
     DICResetAllDDM;
end;

procedure TShowData.Fil0Click(Sender: TObject);
begin
     if Fil0.Checked then DICFilterINC(0,0)
     else DICFilterINC(0,1);
end;

procedure TShowData.Fil1Click(Sender: TObject);
begin
     if Fil1.Checked then DICFilterINC(1,0)
     else DICFilterINC(1,1);
end;

procedure TShowData.Fil2Click(Sender: TObject);
begin
     if Fil2.Checked then DICFilterINC(2,0)
     else DICFilterINC(2,1);
end;

procedure TShowData.Fil3Click(Sender: TObject);
begin
     if Fil3.Checked then DICFilterINC(3,0)
     else DICFilterINC(3,1);
end;

procedure TShowData.Td0Click(Sender: TObject);
begin
     if Td0.Checked then DICTimerDirINC(0,1)
     else DICTimerDirINC(0,0);
end;

procedure TShowData.Td1Click(Sender: TObject);
begin
     if Td1.Checked then DICTimerDirINC(1,1)
     else DICTimerDirINC(1,0);
end;

procedure TShowData.Td2Click(Sender: TObject);
begin
     if Td2.Checked then DICTimerDirINC(2,1)
     else DICTimerDirINC(2,0);
end;

procedure TShowData.Td3Click(Sender: TObject);
begin
     if Td3.Checked then DICTimerDirINC(3,1)
     else DICTimerDirINC(3,0);
end;

procedure TShowData.Aout0IntChange(Sender: TObject);
begin
     DICWriteAnalogInt(0,Aout0Int.Value);
     Aout0Value.Caption:=IntToStr(DICGetAnalogOut(0));

end;

procedure TShowData.Aout1IntChange(Sender: TObject);
begin
    DICWriteAnalogInt(1,Aout1Int.Value);
    Aout1Value.Caption:=IntToStr(DICGetAnalogOut(1));
end;

end.
