(*********************************************************************
	Delphi Unit for DIC.DLL
	(C) 1998 amira GmbH
**********************************************************************)

unit Dic;

interface

function Version : Integer; far;

function DICDRVInit( adr : Integer ) : Integer; far;
function DICGetAdress : Integer; far;
procedure DICSetAdress( adress : Integer ); far;
procedure DICInit; far;
function DICGetInterrupt : Integer; far;
procedure DICSetInterrupt( i : Integer ); far;

function DICGetDigitalOut : word; far;
function DICGetAnalogOut( channel : Integer ) : Integer; far;

function DICReadDigital( channel : Integer ) : Integer; far;
function DICReadAllDigital : Integer; far;
procedure DICWriteDigital ( channel,value : Integer); far;
procedure DICWriteAllDigital( value : Integer); far;

procedure DICWriteAnalogInt( channel , value : Integer); far;
procedure DICWriteAnalogVolt( channel : Integer; value : single ); far;

procedure DICResetDDM( channel : Integer ); far;
procedure DICResetAllDDM; far;
function DICReadDDM( channel : Integer ) : word; far;
procedure DICReadAllDDM; far;

function DICGetDDMCounter( channel : Integer ): word; far;
function DICGetDDMTimer( channel : Integer ) : word; far;
function DICGetDDMStatus( channel : Integer ) : word; far;

procedure DICFilterINC( channel , val : Integer ); far;
procedure DICTimerDirINC( channel , val : Integer ); far;

procedure DICSetINT( channel , val : Integer ); far;

procedure DICSetTimerWord ( time : LongInt ); far;
procedure DICSetTimer( time : double ); far;
procedure DICSetCounter( count : word ); far;
function DICGetTimer : LongInt; far;
function DICGetCounter:Word; far;
procedure DICGateTimer( val : Integer ); far;
procedure DICGateCounter( val : Integer ); far;

implementation

function Version;                  external 'DIC' name 'Version';

function DICDRVInit;               external 'DIC' name 'DICDRVInit';
function DICGetAdress;             external 'DIC' name 'DICGetAdress';
procedure DICSetAdress;            external 'DIC' name 'DICSetAdress';
procedure DICInit;                 external 'DIC' name 'DICInit';
function DICGetInterrupt;          external 'DIC' name 'DICGetInterrupt';
procedure DICSetInterrupt;         external 'DIC' name 'DICSetInterrupt';

function DICGetDigitalOut;         external 'DIC' name 'DICGetDigitalOut';
function DICGetAnalogOut;          external 'DIC' name 'DICGetAnalogOut';

function DICReadDigital;           external 'DIC' name 'DICReadDigital';
function DICReadAllDigital;        external 'DIC' name 'DICReadAllDigital';
procedure DICWriteDigital;         external 'DIC' name 'DICWriteDigital';
procedure DICWriteAllDigital;      external 'DIC' name 'DICWriteAllDigital';

procedure DICWriteAnalogInt;       external 'DIC' name 'DICWriteAnalogInt';
procedure DICWriteAnalogVolt;      external 'DIC' name 'DICWriteAnalogVolt';

procedure DICResetDDM;             external 'DIC' name 'DICResetDDM';
procedure DICResetAllDDM;          external 'DIC' name 'DICResetAllDDM';
function DICReadDDM;               external 'DIC' name 'DICReadDDM';
procedure DICReadAllDDM;           external 'DIC' name 'DICReadAllDDM';

function DICGetDDMCounter;         external 'DIC' name 'DICGetDDMCounter';
function DICGetDDMTimer;           external 'DIC' name 'DICGetDDMTimer';
function DICGetDDMStatus;          external 'DIC' name 'DICGetDDMStatus';

procedure DICFilterINC;            external 'DIC' name 'DICFilterINC';
procedure DICTimerDirINC;          external 'DIC' name 'DICTimerDirINC';

procedure DICSetINT;               external 'DIC' name 'DICSetINT';

procedure DICSetTimerWord;         external 'DIC' name 'DICSetTimerWord';
procedure DICSetTimer;             external 'DIC' name 'DICSetTimer';
procedure DICSetCounter;           external 'DIC' name 'DICSetCounter';
function DICGetTimer;              external 'DIC' name 'DICGetTimer';
function DICGetCounter;            external 'DIC' name 'DICGetCounter';
procedure DICGateTimer;            external 'DIC' name 'DICGateTimer';
procedure DICGateCounter;          external 'DIC' name 'DICGateCounter';

end.
