/*
  Objekt zur Steuerung der amira DIC Karte
  24.03.93 M.Dabrowski
  Dies ist die Header-Datei
*/

unsigned char	ddm_status[4];
unsigned int    ddm_counter[4];
unsigned long	ddm_timer[4];
unsigned char	ddm_adr[4];
unsigned int    output_status_dic0, 	/* Schatten-Register */
		input_status_dic0,
		dic_mode_int;
int		base,
		intr,
		aout0,
		aout1;


unsigned int ReadDigitalInputs( void );
void DIC( int adress );

int GetAdress( void ) { return base; };
void SetAdress( int adress ) { base = adress; };
void Init( void );
int GetInterrupt( void ) { return intr; };
void SetInterrupt( int i ) { intr = i; };


unsigned int GetDigitalOut( void ){ return output_status_dic0;};
int GetAnalogOut( int channel ){ return( channel ? aout1 : aout0 );};

int ReadDigital( int channel );
int ReadAllDigital( void ){ return (int)ReadDigitalInputs(); };
void WriteDigital( int channel, int value );
void WriteAllDigital( int value );
void WriteAnalogInt( int channel, int value );
void WriteAnalogVolt( int channel, float value );

void ResetDDM( int channel );
void ResetAllDDM( void );
unsigned int ReadDDM( int channel );
void ReadAllDDM( void );
unsigned int GetDDMCounter( int channel ){
	  if( channel>=0 && channel<4 ) return ddm_counter[channel];
	  return 0;
	  };
unsigned long GetDDMTimer( int channel ){
	  if( channel>=0 && channel<4 ) return ddm_timer[channel];
	  return 0;
	  };
unsigned char GetDDMStatus( int channel ){
	  if( channel>=0 && channel<4 ) return ddm_status[channel];
	  return 0;
	  };

void FilterINC( int channel, int val );
void TimerDirINC( int channel, int val );

void SetINT( int channel, int val );

void SetTimer( unsigned long time );
/* void SetTimer( double time ); gibt es nur in C++, oder den Namen aendern! */
void SetCounter( unsigned int count );
unsigned long GetTimer( void );
unsigned int GetCounter( void );
void GateTimer( int val );
void GateCounter( int val );
