/*
  Objekt zur Steuerung der amira DIC Karte
  24.03.93 M.Dabrowski
  Dies ist die Funktionsdeklaration
 */

#include <conio.h>              /* Library-Routinen zur Ein-/Ausgabe	*/
#include "dicadr.h"							/* Adressdefinitionen der Karten/Chips	*/
#include "dic.h"								/* Klassen definition 			*/



void DIC( int adress )
{
	base = adress;
	ddm_adr[0]=DDM0;
	ddm_adr[1]=DDM1;
	ddm_adr[2]=DDM2;
	ddm_adr[3]=DDM3;
	Init();
};

/* lesen aller 8 digitalen Eingnge einer DIC-Karte */
unsigned int ReadDigitalInputs( void )
{
	outp ( base+DICCOM, DICDIG ) ;
	input_status_dic0 = inpw ( base+DICDAT ) ;
	return input_status_dic0 & 0x00ff ;
}



void Init( void )
{
	int f;

	/* Alle dig. Ports auf 0 */
	output_status_dic0 = 0x0000;
	outp ( base+DICCOM, DICDIG ) ;
	outpw( base+DICDAT, output_status_dic0 );

	/* Status der dig. Eingaenge holen */
	ReadDigitalInputs();

	/* DIC: keine Int's, kein TimerGate */
	dic_mode_int = 0xff00;
	outpw( base+DICINT, dic_mode_int );

	/* DDM's initialisieren */
	ResetAllDDM();

	/* DIC-Timer initialisieren */
	GateTimer( 0 );
	GateCounter( 0 );
	SetTimer( 0xffffffff );
	SetCounter( 0xffff );
};

int ReadDigital( int channel )
{
	unsigned int mask;

	if( channel<0 ) return 0;
	if( channel<8 ){
	  mask = 0x01<<channel;
	  return( ( ReadDigitalInputs() & mask ) ? 1 : 0 );
	}
	return 0;
};

void WriteDigital( int channel, int value )
{
	if( channel<0 ) return;
	if( channel<8 ){
	  outp ( base+DICCOM, DICDIG ) ;
	  output_status_dic0 = value ?
		    (output_status_dic0 | (0x01<<channel)) :
		    (output_status_dic0 &~(0x01<<channel));
	  outpw( base+DICDAT, output_status_dic0 );
	}
}

void WriteAllDigital( int value )
{
	outp ( base+DICCOM, DICDIG ) ;
	output_status_dic0 &= 0xFF00;
	output_status_dic0 |= (0x00FF & value );
	outpw( base+DICDAT, output_status_dic0 );
}

void WriteAnalogInt( int channel, int value )
{
	unsigned int  addr;
	unsigned char chip;

	if( channel<0 || channel>1 ) return;
	if( channel ){
	  outp( base+DICCOM, DAC5 );
	  aout1=value;
	  }
	else{
	  outp( base+DICCOM, DAC4 );
	  aout0=value;
	  }
	outpw( base+DICDAT, value );
};

void WriteAnalogVolt( int channel, float value )
{
	int v = (int)((value+10.0)/20.0*4096);
	if( v<0 ) v=0;
	if( v>4095 ) v=4095;
	WriteAnalogInt( channel, v );
};

void ResetDDM( int channel )
{
	if( channel<0 || channel>3 ) return;
	outp( base+DICCOM, ddm_adr[channel] );
	outp( base+DICDAT, 0 );
};

void ResetAllDDM( void )
{
		outp( base+DICCOM, DDMX );
		outp( base+DICDAT, 0 );
}

unsigned int ReadDDM( int channel )
{
	if( channel<0 || channel>3 ) return 0;

	/* Register umschalten ( geht nur bei Aenderung der Inremente */
	outp( base+DICCOM, ddm_adr[channel]+1 );
	outp( base+DICDAT, 0 );

	/* Incremente lesen */
	ddm_counter[channel] = 0;
	outp( base+DICCOM, ddm_adr[channel]+DDMINCRHI );
	ddm_counter[channel] = inp( base+DICDAT ) << 8;
	outp( base+DICCOM, ddm_adr[channel]+DDMINCRLO );
	ddm_counter[channel] |= inp( base+DICDAT );

	/* Timer lesen */
	ddm_timer[channel] = 0;
	outp( base+DICCOM, ddm_adr[channel]+DDMTIMEHI );
	ddm_timer[channel] = ( unsigned long )inp( base+DICDAT ) << 16;
	outp( base+DICCOM, ddm_adr[channel]+DDMTIMEMI );
	ddm_timer[channel] |= ( unsigned long )inp( base+DICDAT ) << 8;
	outp( base+DICCOM, ddm_adr[channel]+DDMTIMELO );
	ddm_timer[channel] |= ( unsigned long )inp( base+DICDAT );

	/* Status lesen */
	outp( base+DICCOM, ddm_adr[channel]+DDMSTATUS );
	ddm_status[channel] = inp( base+DICDAT );

	/* Zurueckgegeben wird nur der Counter, der Rest ist 'eh public */
	return( ddm_counter[channel] );
}

void ReadAllDDM( void )
{
	/* alle DDM'S umschalten */
	int f;
	outp( base+DICCOM, DDMX+1 );
	outp( base+DICDAT, 0 );

	for( f=0; f<4; f++){
	  ddm_counter[f] = 0;
	  outp( base+DICCOM, ddm_adr[f]+DDMINCRHI );
	  ddm_counter[f] = inp( base+DICDAT ) << 8;
	  outp( base+DICCOM, ddm_adr[f]+DDMINCRLO );
	  ddm_counter[f] |= inp( base+DICDAT );

	  ddm_timer[f] = 0;
	  outp( base+DICCOM, ddm_adr[f]+DDMTIMEHI );
	  ddm_timer[f] = ( unsigned long )inp( base+DICDAT ) << 16;
	  outp( base+DICCOM, ddm_adr[f]+DDMTIMEMI );
	  ddm_timer[f] |= ( unsigned long )inp( base+DICDAT ) << 8;
	  outp( base+DICCOM, ddm_adr[f]+DDMTIMELO );
	  ddm_timer[f] |= ( unsigned long )inp( base+DICDAT );

	  outp( base+DICCOM, ddm_adr[f]+DDMSTATUS );
	  ddm_status[f] = inp( base+DICDAT );
	  }
}

/* Achtung: val=0 schaltet den Filter ein!! */
void FilterINC( int channel, int val )
{
	if( channel<0 || channel>3 ) return;
	channel <<= 1;
	channel += 8;

	outp ( base+DICCOM, DICDIG ) ;
	output_status_dic0 = val ?
	       (output_status_dic0 | (0x01<<channel)) :
	       (output_status_dic0 &~(0x01<<channel));
	outpw( base+DICDAT, output_status_dic0 );
};

void TimerDirINC( int channel, int val )
{
	if( channel<0 || channel>3 ) return;
	channel <<= 1;
	channel += 9;

	outp ( base+DICCOM, DICDIG ) ;
	output_status_dic0 = val ?
	       (output_status_dic0 | (0x01<<channel)) :
	       (output_status_dic0 &~(0x01<<channel));
	outpw( base+DICDAT, output_status_dic0 );
};

void SetINT( int channel, int val )
{
	if( channel<0 || channel>7 ) return;
	channel += 8;

	dic_mode_int = val ?
	       (dic_mode_int &~(0x01<<channel)) :
	       (dic_mode_int | (0x01<<channel));
	outpw( base+DICINT, dic_mode_int );
};

void SetTimer( unsigned long time )
{
	unsigned int w;

	/* Low Word setzen */
	w = ( unsigned int )time;
	outp( base+DICCOM, TIMER+3 );
	outp( base+DICDAT, 0x36 ); /* Counter0: lsb first, mode 3 */

	outp( base+DICCOM, TIMER+0 );
	outp( base+DICDAT, ( unsigned char)w );
	outp( base+DICDAT, ( unsigned char)(w>>8) );

	/* High Word setzen */
	w = ( unsigned int )(time>>16);
	outp( base+DICCOM, TIMER+3 );
	outp( base+DICDAT, 0x76 ); /* Counter1: lsb first, mode 3 */

	outp( base+DICCOM, TIMER+1 );
	outp( base+DICDAT, ( unsigned char)w );
	outp( base+DICDAT, ( unsigned char)(w>>8) );
};

void SetCounter( unsigned int count )
{
	/* Counter setzen */
	outp( base+DICCOM, TIMER+3 );
	outp( base+DICDAT, 0xb6 ); /* Counter2: lsb first, mode 3 */

	outp( base+DICCOM, TIMER+2 );
	outp( base+DICDAT, ( unsigned char)count );
	outp( base+DICDAT, ( unsigned char)(count>>8) );
};

unsigned long GetTimer( void )
{
	unsigned long wert=0;

	/* Low Word lesen */
	outp( base+DICCOM, TIMER+3 );
	/* outp( base+DICDAT, 0x36 );  Counter0: lsb first, mode 3 */
	outp( base+DICDAT, 0x06 ); /* Counter0: lsb first, mode 3, on the fly */

	outp( base+DICCOM, TIMER+0 );
	wert  = (unsigned long)inp( base+DICDAT );
	wert |= (unsigned long)inp( base+DICDAT ) << 8;

	/* High Word lesen */
	outp( base+DICCOM, TIMER+3 );
	/* outp( base+DICDAT, 0x76 );  Counter1: lsb first, mode 3 */
	outp( base+DICDAT, 0x46 ); /* Counter1: lsb first, mode 3, on the fly */

	outp( base+DICCOM, TIMER+1 );
	wert |= (unsigned long)inp( base+DICDAT ) << 16;
	wert |= (unsigned long)inp( base+DICDAT ) << 24;

	return wert;
};

unsigned int GetCounter( void )
{
	unsigned int wert=0;

	/* Counter setzen */
	outp( base+DICCOM, TIMER+3 );
	/* outp( base+DICDAT, 0xb6 );  Counter2: lsb first, mode 3 */
	outp( base+DICDAT, 0x86 ); /* Counter2: lsb first, mode 3, on the fly */

	outp( base+DICCOM, TIMER+2 );
	wert  = ( unsigned int )inp( base+DICDAT );
	wert |= ( unsigned int )inp( base+DICDAT ) << 8;

	return wert;
};

void GateTimer( int val )
{
	dic_mode_int = val ?
	       (dic_mode_int | 0x0003) :
	       (dic_mode_int &~(0x0003));
	outpw( base+DICINT, dic_mode_int );
};

void GateCounter( int val )
{
	dic_mode_int = val ?
	       (dic_mode_int | 0x0004) :
	       (dic_mode_int &~(0x0004));
	outpw( base+DICINT, dic_mode_int );
};
