// Objectdefinition fuer die amira-PC-IO-Karte
// (c)1992 amira GmbH
// Programmierer: M. Dabrowski
// Stand 04.09.1995



/*
Dieses Objekt dient dazu die PCIO-Karte DAC6214 der Fa. amira
komfortabel anzusprechen.
*/

_CLASSDEF(PCIO)

class PCIO {
private:
	int	base, 		// = IO_BASE_ADDR;
		data_port, 	// = IO_BASE_ADDR+3;
		cmd_port, 	// = IO_BASE_ADDR+2;
		dma_channel, 	// Dma Kanal ( nur im Zusammenhang mit V40 )
		interrupt_channel;	// Interrupt Kanal ( s. Timerzusatz )
	unsigned char	output_status,	// digitaler Status
		out_reg,      	//
		gate_int;     	// Interrupt-Gates ( s. Timerzusatz )
	unsigned char                    // Baustein-Adressen:
		DAC1,  		// DA-Converter 1
		DAC2,		// DA-Converter 2
		ADC,           	// AD-Converter
		DIGITAL_IN,    	// Digital In
		DIGITAL_OUT,  	// Digital Out
		HCTL_RESET,   	// HCTL Reset
		HCTL_HIGH,    	// HCTL HighByte
		HCTL_LOW,  	// HCTL LowByte
		TIMER,      		// org. 'WD_SEL'
		DIGITAL_OUT2;		// org. 'SIO_SEL'

private:
	// setzt die Basis-Adresse der Karte
	void SelectAdress( unsigned char addr ){outp( base, addr );};

        // waehlt einen Analog-Kanal aus
	void SelectChannel( int channel );

        // liest alle digitalen Zustaende
	unsigned char ReadDigitalInputs( void );

        // setzt die digitalen Zustaende
	void DigOut( unsigned char data );

public:
	// Der Konstruktor benoetigt nur die Basisadresse der Karte
	PCIO( int adress );

        // Der Destruktor braucht keine Parameter
	~PCIO(){};

        // Liest den angegebenen Analogkanal und liefert seinen Wert.
	int 	ReadAnalogInt( int channel );

	// Liest den angegebenen Analogkanal und liefert seine Spannung
        // in Volt
	float   ReadAnalogVolt( int channel );

	// Liest den angegebenen Analogkanal ( channel ) mehrfach
	// ( repeat mal ) und liefert den Mittelwert als Sapnnung in
        // Volt.
	float	ReadAnalogVoltMean( int channel, int repeat );

	// gibt einen Analogwert ( value ) auf den angegebenen Kanal
	// ( channel ) aus.
	void    WriteAnalogInt( int channel, int value );

	// wie bei "WriteAnalogInt", jedoch wird der Wert als Spannung
	// angegeben
	void 	WriteAnalogVolt( int channel, float value );

        // setzt den HCTL zurueck.
	void 	ResetHCTL( void );

        // liest den 12Bit Zaehler des HCTL
	int	ReadHCTL( void );

        // liefert den Zustand des uebergebenen digitalen Eingangskanals
	int	ReadDigital( int channel );

	// setzt den Zustand ( value ) des uebergebenen Ausgangskanals
        // ( channel ).
	void	WriteDigital( int channel, int value );

        // liefert den digitalen Status der Karte.
	unsigned char	DigitalOutStatus( void ){ return out_reg;};

	// testet die amira DAC6214 auf vorhandensein an der spez.
	// Adresse.
        // ( momentan 28.06.1993 noch nicht ausgereift )
	int	IsPCIO( void );

	// liefert die eingestellte Basisadresse der Karte zurueck.
	int	GetAdress( void ){ return base; };

	// setzt die Basisadresse auf einen neuen Wert.
	void 	SetAdress( int adr){
		base		= adr;
		data_port	= base+3;
		cmd_port	= base+2;
		};

	// liefert den eingestellten Interrupt der Karte zurueck.
	int 	GetInterrupt( void ){ return interrupt_channel;};

	// setzt den Interrupt auf einen neuen Wert.
	void 	SetInterrupt( int i ){ interrupt_channel = i;};

        //
	// folgende Funktionen arbeiten nur mit dem 'TIMER - ADAPTER'
	//

        // setzt das Interrupt-Freigaberegister der DAC6214
	void SetINT( int val );

        // Programmiert den Timer auf die angegebene Periode
	void SetTimer( unsigned long time );

	// Programmiert den Timer auf die angegebene Periode in ms
	void SetTimer( double time );

				// Programmiert den Counter auf die angegebene Periode
	void SetCounter( unsigned int count );

        // liefert den Zaehlerstand des Timers.
	unsigned long GetTimer( void );

        // liefert den Zaehlerstand des Counters.
	unsigned int GetCounter( void );

        // setzt die Freigabe fuer den Timer
	void GateTimer( int val );

        // setzt die Freigabe fuer den Counter
	void GateCounter( int val );
};
