/*
  Objectdefinition fuer die amira-PC-IO-Karte
  (c)1992 M. Dabrowski
*/

#include <conio.h>

/* diese Definitionen sind fuer "IO.H" wichtig ! */
#define BYTE	unsigned char
#define BOOL	unsigned int

#include "io.h"


void PCIO( int adress )
{
	base		= adress;
	data_port	= base+3;
	cmd_port	= base+2;
	dma_channel	= 0;		/* nicht verwendet */
	interrupt_channel	= 0;	/* nicht verwendet */
	output_status 	= 0 ;
	out_reg		= 0 ;
	gate_int 	= 0 ;
	DAC1 	= 0x20;
	DAC2 	= 0x40;
	ADC  	= 0x00;
	DIGITAL_IN 	= 0x60;
	DIGITAL_OUT 	= 0xa0;
	HCTL_RESET 	= 0x80;
	HCTL_HIGH 	= 0x88;
	HCTL_LOW 	= 0x89;
	TIMER		= 0xE0;
	DIGITAL_OUT2	= 0xC0;
};

void SelectChannel( int channel )
{
	SelectAdress ( DIGITAL_OUT ) ;
	output_status = (output_status & 0x8F) | ( ((BYTE)channel<<4) & 0x70 ) ;
	outp ( data_port, output_status ) ;
};

BYTE ReadDigitalInputs( void )
{
	SelectAdress ( DIGITAL_IN ) ;
	return (inp ( data_port )  & 0x0f ) ;
};

void DigOut ( BYTE data )
{
	SelectAdress ( DIGITAL_OUT ) ;
	output_status = (output_status & 0xf0) | (data & 0x0f) ;
	outp ( data_port, output_status ) ;
};

BOOL ReadDigital( int channel )
{
	BYTE mask;
	mask = 0x01<<channel;
	return( ( ReadDigitalInputs() & mask ) ? 1 : 0 );
};

void WriteDigital( int channel, int value )
{
	out_reg = value ? (out_reg | (0x01<<channel)) : (out_reg &~(0x01<<channel));
	DigOut( out_reg );
};

int  ReadAnalogInt( int channel )
{
	int adc_word ;
	SelectChannel ( channel ) ;
	SelectAdress ( DIGITAL_IN ) ;
	while(!( inp( data_port ) & 0x80) );	/* Busy poll */
	SelectAdress ( ADC ) ;
	inp ( data_port ) ;			/* start conversion */
	SelectAdress ( DIGITAL_IN ) ;
	while(!( inp( data_port ) & 0x80) );	/* Busy poll */

	SelectAdress ( ADC+1 ) ;
	adc_word  = ( inp ( data_port ) << 8 ) & 0x0F00 ;
	SelectAdress ( ADC ) ;
	adc_word |= inp ( data_port ) ;
	return (2048-adc_word) ;		/* range: +-2048 */
};

float ReadAnalogVolt( int channel )
{
	return( (float)ReadAnalogInt(channel) / 204.8 );
};

float ReadAnalogVoltMean( int channel, int repeat )
{
	float 	mean;
        int 	count;

	mean = 0.0;
	for( count=0; count<repeat; count++ )
		mean += ReadAnalogVolt( channel );
	mean /= (float)repeat;
        return( mean );
};


void WriteAnalogInt( int channel, int value )
{
	BYTE addr;
	value+=2048;
	addr = (channel==0) ? DAC1 : DAC2 ;
	SelectAdress ( addr++ ) ;
	outp ( data_port, value & 0x0f );
	SelectAdress ( addr++ ) ;
	outp ( data_port, (value>>4) & 0x0f ) ;
	SelectAdress ( addr++ ) ;
	outp ( data_port, (value>>8) & 0x0f ) ;
	SelectAdress ( addr ) ;
	outp ( data_port, 0 ) ;
};

void WriteAnalogVolt( int channel, float value )
{
	float val;
	/* Bereichsueberwachung */
	if( value > 9.9 ) val = 9.9;	/* Besser: 9.9951 */
	else if( value < -9.9 ) val = -9.9;
	else val = value;
	WriteAnalogInt( channel, (int)(val*204.8));
};

void ResetHCTL( void )
{
	SelectAdress( HCTL_RESET );
	inp( data_port );
};

int	ReadHCTL( void )
{
	int	wert = 0;
	SelectAdress( HCTL_HIGH );
	wert = inp( data_port ) << 8;
	SelectAdress( HCTL_LOW );
	wert |= inp( data_port );
	return( wert );
};

BOOL IsPCIO( void )
{
/*  Diese Routine ist in ihrer derzeitigen Form ein Provisorium !!! */
	int	in, count;
	float	x;

	WriteAnalogInt( 0, 1000 );
	x= 10000.0;
	for( count=1; count<1000; count++ ) x=x/10.0;
	in = ReadAnalogInt( 7 );
	WriteAnalogInt( 0, 0 );
	if( (1000-in)>300 || (in-1000)>300 ) return 0;
	else return 1;
};

void SetINT( int val )
{
	gate_int = val ?
	       ( gate_int | 0x02  ) :
	       ( gate_int &~ 0x02 );
	SelectAdress( DIGITAL_OUT2 );
	outp( data_port, gate_int );
};

void SetTimer( unsigned long time )
{
	unsigned int w;

	/* Low Word setzen */
	w = ( unsigned int )time;
	SelectAdress( TIMER+3 );
	outp( data_port, 0x76 ); /* Counter1: lsb first, mode 3 */

	SelectAdress( TIMER+1 );
	outp( data_port, ( unsigned char)w );
	outp( data_port, ( unsigned char)(w>>8) );

	/* High Word setzen */
	w = ( unsigned int )(time>>16);
	SelectAdress( TIMER+3 );
	outp( data_port, 0xb6 ); /* Counter2: lsb first, mode 3 */

	SelectAdress( TIMER+2 );
	outp( data_port, ( unsigned char)w );
	outp( data_port, ( unsigned char)(w>>8) );
};

void SetCounter( unsigned int count )
{
	/* Counter setzen */
	SelectAdress( TIMER+3 );
	outp( data_port, 0x36 ); /* Counter0: lsb first, mode 3 */

	SelectAdress( TIMER+0 );
	outp( data_port, ( unsigned char)count );
	outp( data_port, ( unsigned char)(count>>8) );
};

unsigned long GetTimer( void )
{
	unsigned long wert=0;

	/* Low Word lesen */
	SelectAdress( TIMER+3 );
	outp( data_port, 0x46 ); /* Counter1: on the fly, mode 3 */

	SelectAdress( TIMER+1 );
	wert  = (unsigned long)inp( data_port );
	wert |= (unsigned long)inp( data_port ) << 8;

	/* High Word lesen */
	SelectAdress( TIMER+3 );
	outp( data_port, 0x86 ); /* Counter2: on the fly, mode 3 */

	SelectAdress( TIMER+2 );
	wert |= (unsigned long)inp( data_port ) << 16;
	wert |= (unsigned long)inp( data_port ) << 24;

	return wert;
};

unsigned int GetCounter( void )
{
	unsigned int wert=0;

	/* Counter setzen */
	SelectAdress( TIMER+3 );
	outp( data_port, 0x06 ); /* Counter0: on the fly, mode 3 */

	SelectAdress( TIMER+0 );
	wert  = ( unsigned int )inp( data_port );
	wert |= ( unsigned int )inp( data_port ) << 8;

	return wert;
};

void GateTimer( int val )
{
	gate_int = val ?
	       ( gate_int | 0x01  ) :
	       ( gate_int &~ 0x01 );
	SelectAdress( DIGITAL_OUT2 );
	outp( data_port, gate_int );
};

void GateCounter( int val )
{
	gate_int = val ?
	       ( gate_int | 0x04  ) :
	       ( gate_int &~ 0x04 );
	SelectAdress( DIGITAL_OUT2 );
	outp( data_port, gate_int );
};