#include <conio.h>
#include <stdio.h>

#include "..\..\driver\cpp\dac98.h"

// define the base address of the PC adapter card DAC98.
#define address 0x300

// create a new instance of the class DAC98
DAC98 io(address);

void main ( void )
{
   clrscr();

   // checks whether the amira DAC98 responds to the base address 
   if (io.Identifikation())
   {
      // adjusts the clock rate for the timer device to the given value.
      io.SetClock( DAC98::Clk62kHz );

      // sends the analog value (5.0V) to the channel (0)
      io.WriteAnalogVolt(0,5.0);

      // disables the gate of the 32 bit timer
      io.GateTimer( 0 );

      // adjusts the initial value for the 32 bit counter 
      io.SetTimer( 0xffffffff );

		// enables the gate of the 32 bit timer
      io.GateTimer( 1 );

      gotoxy(20,1);printf("Break test of DAC98 with any key!");

      while (!kbhit())
      {
	 for ( int i=0 ; i<8 ; i++)
	 {
	    gotoxy(10,4+i);

		//  reads the analog input channel specified by channel (i) and
		//	 returns the corresponding voltage value with respect to the
		//  input signal range given by mode (3)
		//  the result is displayed on the screen
		 printf("% 1d. Analog  Input : % 8.5f",i,io.ReadAnalogVolt(i,3));

	    gotoxy(10,13+i);

		 // returns the state (0 or 1) of the digital input channel (i).
		 printf("% 1d. Digital Input : % 1d",i,io.ReadDigital(i));
	 }

	 gotoxy(14,22);
	// returns the 32 bit timer register content.
	 printf("Timerwert     :% 8d ",io.GetTimer());

      }

      // disables the gate of the 32 bit timer
      io.GateTimer( 0 );

      clrscr();
   }
   else printf("No DAC98 Present");
}

