unit Testdll;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls,
  DAC98;

type
  TShowData = class(TForm)
    ShowData: TTimer;
    AnalogWert: TLabel;
    ShowAIN0: TLabel;
    TimerWert: TLabel;
    ShowTimer: TLabel;
    procedure ShowDataTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  ShowData: TShowData;
  DACADR : integer;

implementation

{$R *.DFM}

procedure TShowData.ShowDataTimer(Sender: TObject);

var Ain0Str : string[10];

begin
     if DAC98Identifikation=1 then
     begin
          Str(DAC98ReadAnalogVolt(0,3):9:3, Ain0Str);

          ShowAIN0.Caption:=Ain0Str;

          ShowTimer.Caption:=IntToSTr(DAC98GetTimer);
     end;
end;

procedure TShowData.FormCreate(Sender: TObject);
begin
  DACADR:=$300;

  if 0 = DAC98Init( DACADR ) then
    MessageDlg('Not enough memory for DAC98-Object generation', mtError, [mbOK], 0)
  else

  if 0 = DAC98Identifikation then
  begin
    MessageDlg('DAC98 not found at address '+IntToHex(DACADR,3), mtError, [mbOk], 0);
  end
  else
  begin
    DAC98GateTimer(0);
    DAC98SetTimerWord($ffffffff);
    DAC98GateTimer(1);
  end;
end;

end.
