// Objekt zur Steuerung der amira DAC98 Karte
// Stand 12.11.1997 B.Osterkamp
// Dies ist die Header-Datei

/* Adressdefinitionen */

/* Adressen der Chips */
#define DAC98ID		0x0055	// HardwareIdentitt der DAC98

#define Iden_CS	  	0x0000	// /CS0  : Identifikation
#define ADW_CS		0x0008	// /CS1  : ADW
#define DAW0_CS		0x0010	// /CS2  : DAW0
#define DAW1_CS		0x0018	// /CS3  : DAW1
#define Timer_CS	0x0020	// /CS4  : Timer
#define IO_CS  		0x0028	// /CS5  : IO
#define DDM02a_CS  	0x0030	// /CS6  : DDM02a
#define DDM02b_CS  	0x0038	// /CS7  : DDM02b
#define DDM02c_CS  	0x0078	// /CS8  : DDM02c
#define CSDDMALL_CS  	0x00BA	// /CS9  : CSDDMALL
#define Interrupt_CS	0x00F8	// /CS10 : Interrupt

/* DDM-Register */
#define DDMINCRHI	0x00
#define DDMINCRLO	0x01

// Die Klasse DAC98
class DAC98{
public:
	unsigned int    ddm_counter[3];
	enum Clkmodes {Clk8MHz=0,Clk4MHz=1,Clk2MHz=2,Clk1MHz=3,Clk500kHz=4,Clk250kHz=5,Clk125kHz=6,Clk62kHz=7};
	int aout0, aout1;


protected:
	unsigned char	ddm_adr[3];
	unsigned long   timer_counter0,timer_counter1;
	unsigned int	timer_counter2;


	int Base	;	// Basisadresse der DAC98

	int WR_DATA 	;	// Datenregister schreiben
	int RD_DATA 	;	// Datenregister auslesen
	int intr	;
	double Clock    ;
	int CounterGate ;
	int CounterJMP	;

	// Variablen der Digitalen Kanle
	int output_status_DAC98;// Registerzustand der digitalen Ausgnge
	int input_status_DAC98; // Registerzustand der digtialen Eingnge
	int intr_status;        // Zustand des Interruptsregisters


protected:
	// Einlesen der digitalen Eingnge
	unsigned int ReadDigitalInputs( void );

public:
	// Der Konstruktor bentigt nur die Basisadresse
	DAC98( int adress = 0x300 );

	// Der Destruktur braucht keine Parameter
	~DAC98( void );

	// liefert die eingestellte Basisadresse zurck
	int GetAdress( void ) { return Base; };

	// setzt die Basisadresse auf einen neuen Wert
	void SetAdress( int adress ) { Base = adress; };

	// liefert den eingestellten Interruptkanal zurck
	int GetInterrupt( void ) { return intr; };

	// setzt den Interrupt auf einen neuen Wert
	void SetInterrupt( int i ) { intr = i; };

	// Auslesen der Identifikation-Bitfolge
	int Identifikation( void );

	// Initialisieren der Bausteine
	void Init ( void );

	// Karte in den Grundzustand bringen
	int Exit ( void );

	// Adresse der DAC98 suchen
	int Setup (void);

	// setzt den internen Clockmode fr den Timer/Counter
	void SetClock( int mode );

	// liefert den eingestellten Clockmode zurck
	double GetClock( void ) {return Clock;};

	// Kanalweise die Digitalen Kanle schreiben
	void WriteDigital (int channel, int value);

	// Alle Digitalen Kanle auf val setzen
	void WriteAllDigital( int value );

	// einen Digital-Eingang lesen
	int ReadDigital( int channel );

	// Einlesen der digitalen Eingnge
	int ReadAllDigital( void ){return (int)ReadDigitalInputs();};

	// Den Counter setzen
	void SetCounter(unsigned int count);

	// liefert den Zaehlerstand des Counters.
	unsigned int GetCounter( void );

	// Delayroutine mit Hilfe des Counter, die Zeit wird in ms bergeben
	int WaitCounter(double time);

	// Routine zum berprfen des Frequenzjumpers
	int TestCounterJMP( void );

	// Den Counter starten
	void GateCounter( int val );

	// Den Timer setzen
	void SetTimer ( unsigned long time );

	// Den Timer in ms setzen
	void SetTimer( double time );

	// liefert den Zaehlerstand des Timers.
	unsigned long GetTimer( void );

	// Den Timer starten
	void GateTimer( int val );

	// setzt das Interrupt-Freigaberegister der DAC98
	void SetINT( int channel, int val );

	int GetINT( void );

	// liet das Interruptregister zurck
	int GetINT( int channel );

	// einen DDM zurcksetzen
	void ResetDDM( int channel );

	// alle DDM zurcksetzen
	void ResetAllDDM( void );

	// einen DDM lesen
	unsigned int ReadDDM( int channel );

	// alle DDM lesen
	void ReadAllDDM( void );

	// einen Anaglogen Kanal mit dem entsprechenden Mode lesen
	// default +-10V
	int  ReadAnalogInt( int channel , int mode=3);

	// einen Anaglogen Kanal mit dem entsprechenden Mode lesen
	// default +-10V mit  der Ausgabe in V
	float  ReadAnalogVolt( int channel , int mode=3);

	// gibt einen Analogwert auf einem bestimmten Kanal aus
	void WriteAnalogInt( int channel, int value );

	// gibt einen Analogwert in Volt auf einem bestimmten Kanal aus
	void WriteAnalogVolt( int channel, float value );

};


// Die Klasse DIC simuliert die DIC24 mit Hilfe der DAC98
class DIC : public DAC98 {
public:
	unsigned char	ddm_status[4];
	unsigned int    ddm_counter[4];
	unsigned long	ddm_timer[4];

	int aout0, aout1;	// Wert der Analogen Ausgnge
private:
	int ident;
public:
	// Der Konstruktor bentigt nur die Basisadresse
	DIC(int adr);

	// Der Destruktur braucht keine Parameter
	~DIC();

	// Liefert den Status der digitalen Ausgnge zurck
	unsigned int GetDigitalOut(void){return output_status_DAC98;};

	// Liefert die Werte der analogen Ausgnge zurck
	int GetAnalogOut (int channel) {return (channel ? aout1 : aout0);}

	// Liefert den Zhlerstand des entsprechendne DDM zurck
	unsigned int GetDDMCounter( int channel ){
	  if( channel>=0 && channel<3 ) return ddm_counter[channel];
	  return 0;
	  };

	// Liefert den Timerstand 0 bei jedem Kanal zurck,
	// da diese Funktion im neuen DDM nicht mehr vorhanden ist
	unsigned long GetDDMTimer( int channel ){  return 0L; };

	// Liefert den Status 0 bei jedem Kanal zurck,
	// da diese Funktion im neuen DDM nicht mehr vorhanden ist
	unsigned char GetDDMStatus( int channel ){ return 0; };

	// Beinhaltet eine Leerfunktion,
	// da diese Funktion im neuen DDM nicht mehr vorhanden ist
	void FilterINC( int channel, int val ){};

	// Beinhaltet eine Leerfunktion,
	// da diese Funktion im neuen DDM nicht mehr vorhanden ist
	void TimerDirINC( int channel, int val ){};

	// setzt das Interrupt-Freigaberegister der DAC98
	void SetINT( int channel, int val );

	// Den Timer setzen
	void SetTimer ( unsigned long time );

	void SetTimer( double time )
	{
		DAC98::SetTimer( time );
	};

	// liefert den Zaehlerstand des Timers.
	unsigned long GetTimer( void );

};

// Die Klasse PCIO simuliert die DAC6214 mit Hilfe der DAC98
class PCIO : public DAC98{
public:
	unsigned int    ddm_counter[1];
public:
	// Der Konstruktor bentigt nur die Basisadresse
	PCIO(int adr);

	// Der Destruktur braucht keine Parameter
	~PCIO();

	// liefert den digitalen Ausgangsstatus der Karte zurck
	unsigned int DigitalOutStatus(void);

	// konntroliert ob eine DAC-Mekarte im PC steckt
	// wertet die Identifikation der DAC98 aus
	// und nicht mehr die zurckgelesenen Analogwerte
	int IsPCIO(void);

	// Lierfert den Mittelwert von mehreren Messungen zurck
	float ReadAnalogVoltMean(int channel, int repeat);

	// Resetet den ersten DDM
	void ResetHCTL(void);

	// liest den ersten DDM aus
	int ReadHCTL(void);

	// Setzt den Interruptkanal des Timerbausteins
	void SetINT( int val );

};
